
# ----- Ground water drainage measurements ---------
library(scales)

rootDirectory = 'F:/Manuscripts/Chapter 1 Manuscript submission & data/4TU Data/Figure 5 - ground water drainage/'
inputDirectory = paste(rootDirectory,'CSV/',sep = '')

# setwd(rootDirectory)
# tiff("Figure 5.tif",
#      width = 7, height = 6, 
#      units = 'in', res = 300)

pointColSeq = c('darkblue','darkgreen','black')
lineColSeq = c('blue','green','yellow')

photoInterval.minutes = 5
interval = 1

plot(c(1), type = 'n', 
     ylim = c(-2,2), 
     xlim = c(0, 10), log = '',
     ylab = 'Ground water depth (cm)',
     yaxt = 'n',
     xlab = 'Time since onset of low tide (hours)')
axis(side = 2, at = c(seq(-2,2,1)), label = rev(c(seq(-2,2,1))))

H = c()
time = c()
tide = c()
replicate = c()
sedShape = c()
setwd(inputDirectory)
for (i in 1:length(dir(inputDirectory))){
  setwd(inputDirectory)
  d = read.csv(dir(inputDirectory)[i])
  fileName = unlist(strsplit(dir(inputDirectory)[i], '.csv'))
  fileInfo = unlist(strsplit(fileName, '_'))
  sedimentShape = fileInfo[1]
  replicate.ID = as.numeric(unlist(strsplit(fileInfo[2],'pot'))[2])
  tide.ID = as.numeric(unlist(strsplit(fileInfo[3],'tide'))[2])
  
  tideDuration.hours = c((10628 - 10143)/60,  #114GOPRO
                         ((11118 - 10813) + (10251 - 10001))/60, #114GOPRO - #115GOPRO
                         (10946 - 10406)/60, #115GOPRO
                         (10691 - 10126)/60, #116GOPRO
                         ((10996 - 10846) + (10386 - 10001))/60, #116GOPRO - #117GOPRO
                         ((10996 - 10566) + (10031 - 10001))/60, #117GOPRO - #118GOPRO
                         ((10996 - 10506) + (10071 - 10001))/60, #119GOPRO - #120GOPRO
                         (10766 - 10226)/60, #120GOPRO
                         (11530 - 10990)/60, #120GOPRO
                         ((11900 - 11710) + (10376 - 10001))/60, #120GOPRO - #121GOPRO
                         (11058 - 10518)/60, #121GOPRO
                         ((11378 - 11238) + (10426 - 10001))/60, #121GOPRO - #122GOPRO.1
                         (11111 - 10561)/60, #122GOPRO
                         ((11441 - 11286) + (10411 - 10001))/60, #122GOPRO - #123GOPRO
                         ((10996 - 10566) + (10111 - 10001))/60) #123GOPRO - #124GOPRO
  
  if(sedimentShape == 'hummock'){
    col = 1
  } else if(sedimentShape == 'flat'){
    col = 2
  } else if(sedimentShape == 'hollow'){
    col = 3
  }
  
  xOrigin = d$X[1]
  yOrigin = d$Y[1]
  
  x = d$X[-c(1:5)]
  y = d$Y[-c(1:5)]
  
  time.hours = seq(0, tideDuration.hours[tide.ID], length.out = length(x))
  
  xMean = c()
  yMean = c()
  timeMean = c()
  
  n_windows = floor(length(x)/interval)
  #for(i_window in 1:n_windows){
  #start = 1 + (i_window - 1)*interval
  #end = i_window*interval
  
  for(i_window in 1:length(x)){
    start = i_window
    end = start + interval
    
    xMean[i_window] = mean(x[start:end], na.rm = T)
    yMean[i_window] = mean(y[start:end], na.rm = T)
    timeMean[i_window] = min(time.hours[start:end], na.rm = T)
  }
  
  H.cm = sqrt((xMean - xOrigin)^2 + (yMean - yOrigin)^2)
  time.hours = timeMean
  
  H.cm[H.cm > 3] = NA
  H.cm = H.cm - max(H.cm, na.rm = T)
  if(sedimentShape == 'hollow'){
    H.cm = H.cm + 2
  }
  points(H.cm ~ time.hours, pch = '.', col = pointColSeq[col])

  H = c(H, H.cm)
  time = c(time, time.hours)
  tide = c(tide, rep(tide.ID, times = length(H.cm)))
  replicate = c(replicate, rep(i, times = length(H.cm)))
  sedShape = c(sedShape, rep(sedimentShape, times = length(H.cm)))
}

sedShape = factor(sedShape, levels = c('hummock','flat','hollow'))

for(i_sediment in 1:3){
  if(i_sediment == 1){
    i_sediment = 1
    y = H[H != 0 & sedShape == levels(sedShape)[i_sediment]]
    x = time[H != 0 & sedShape == levels(sedShape)[i_sediment]]
    m1 = nls(y ~ exp(a + b*x) + c, start = list(a = 0.1, b = -0.2, c= -2))
    summary(m1)
    a = summary(m1)$coefficients[1]
    b = summary(m1)$coefficients[2]
    c = summary(m1)$coefficients[3]
    xv = seq(0, max(time,na.rm = T), length.out = 1000)
    yv = exp(a + b*xv) + c
  
  } else if (i_sediment == 2){
    i_sediment = 2
    y = H[H != 0 & sedShape == levels(sedShape)[i_sediment]]
    x = time[H != 0 & sedShape == levels(sedShape)[i_sediment]]
    # m2b = nls(y ~ exp(a + b*x) + c, start = list(a = 2, b = -0.2, c = -2))
    # summary(m2b)
    # a = summary(m2b)$coefficients[1]
    # b = summary(m2b)$coefficients[2]
    # c = summary(m2b)$coefficients[3]
    # xv = seq(0, max(time,na.rm = T), length.out = 1000)
    # yv = exp(a + b*xv) + c

    m2 = lm(y ~ x + 0)
    summary(m2)
    #a = summary(m2)$coefficients[1]
    #b = summary(m2)$coefficients[2]
    b = summary(m2)$coefficients[1]
    xv = seq(0, max(time,na.rm = T), length.out = 1000)
    yv = b*xv# + a 
    b
    # AIC(m2,m2b)
  } else if (i_sediment == 3){
    i_sediment = 3
    y = H[H != 0 & sedShape == levels(sedShape)[i_sediment]]
    x = time[H != 0 & sedShape == levels(sedShape)[i_sediment]]
    m3 = lm(y ~ x)
    summary(m3)
    a = summary(m3)$coefficients[1]
    b = summary(m3)$coefficients[2]
    xv = seq(0, max(time,na.rm = T), length.out = 1000)
    yv = b*xv + a 
  
  }
  lines(yv ~ xv, lwd = 2, col = alpha(lineColSeq[i_sediment],0.5))
}
summary(m1)$coefficients[2]
m2$coefficients[1]
m3$coefficients[1]
lines(y = c(0,0), x = c(0,10), col = alpha('black',0.5), lwd = 2, lty = 2)
text(y = 0.2, x = 8, 'Sediment surface', col = alpha('black',0.5))
text(y = 1.65, x = 5, 'Lowered', col = alpha('darkkhaki',0.8), srt = -2)
text(y = -0.48, x = 4, 'Flat', col = alpha('darkgreen',0.8), srt = -8)
text(y = -1.35, x = 3.3, 'Raised', col = alpha('darkblue',0.8), srt = -20)

#dev.off()

groundWaterDepth.cm = H
timeSinceHighTide.hours = time
Tide.ID = tide
unique.ID = replicate
sedimentShape = sedShape
output = data.frame(groundWaterDepth.cm, timeSinceHighTide.hours, Tide.ID, unique.ID, sedimentShape)

# setwd(rootDirectory)
# write.csv(output, 'Figure 5 - drainage experiment wooden sticks.csv', row.names = F)

# ----------------------------------------
filter = timeSinceHighTide.hours > 8.5
tapply(groundWaterDepth.cm[filter], sedimentShape[filter], length)
plot(groundWaterDepth.cm[filter] ~ sedimentShape[filter], ylim = c(-2,2), col = alpha(lineColSeq,0.5), pch = '')
points(groundWaterDepth.cm[filter] ~ sedimentShape[filter], pch = 21, bg = alpha(lineColSeq[sedimentShape[filter]],0.5))

diff(tapply(groundWaterDepth.cm[filter], sedimentShape[filter], mean))[1]
mean(tapply(groundWaterDepth.cm[filter], sedimentShape[filter], sd)[1:2]/sqrt(tapply(groundWaterDepth.cm[filter], sedimentShape[filter], length)[1:2]))
range(groundWaterDepth.cm[sedimentShape == 'hollow'])

